/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Numbers;

import BryceMath.Numbers.Complex;
import BryceMath.Numbers.IntB;
import BryceMath.Numbers.Multinomial;
import BryceMath.Numbers.Number;
import BryceMath.Numbers.NumberMath;
import BryceMath.Numbers.Rational;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.List;
import java.io.PrintStream;

public class Expression
extends Number<Expression>
implements Comparable<Expression> {
    private Multinomial num;
    private Multinomial denom;
    public static final Expression ZERO = new Expression(0L);
    public static final Expression ONE = new Expression(1L);

    public Expression(Multinomial numerator, Multinomial denominator) {
        this.num = numerator;
        this.denom = denominator;
        this.simplify();
    }

    public Expression(long numerator, long denominator) {
        this.num = this.I(numerator);
        this.denom = this.I(denominator);
        this.simplify();
    }

    public Expression(Multinomial numerator) {
        this.num = numerator;
        this.denom = Multinomial.ONE;
    }

    public Expression(long numerator) {
        this.num = this.I(numerator);
        this.denom = Multinomial.ONE;
    }

    public Expression(IntB numerator) {
        this.num = new Multinomial(numerator);
        this.denom = Multinomial.ONE;
    }

    public Expression(Rational numerator) {
        this.num = new Multinomial(numerator);
        this.denom = Multinomial.ONE;
    }

    public Expression(Complex numerator) {
        this.num = new Multinomial(numerator);
        this.denom = Multinomial.ONE;
    }

    public Expression(String numerator) {
        this.num = new Multinomial(numerator);
        this.denom = Multinomial.ONE;
    }

    public Expression(double input) {
        String s = "" + input % 1.0;
        int len = s.length();
        this.denom = this.I(1L);
        this.num = this.I((long)input);
        input %= 1.0;
        int i = 1;
        while (i < len - 1) {
            this.num = (Multinomial)this.num.mult(10);
            this.denom = (Multinomial)this.denom.mult(10);
            this.num = this.num.add(this.I((long)(input *= 10.0)));
            input %= 1.0;
            ++i;
        }
        this.simplify();
    }

    @Override
    public Expression one() {
        return ONE;
    }

    @Override
    public Expression zero() {
        return ZERO;
    }

    @Override
    public Expression add(Expression input) {
        if (input.eq(ZERO)) {
            return this;
        }
        if (this.eq(ZERO)) {
            return input;
        }
        Expression r1 = this.clone();
        Expression r2 = input.clone();
        Multinomial denom_out = this.normilize_denominators(r1, r2);
        Expression output = new Expression(r1.getNum().add(r2.getNum()), denom_out);
        return output;
    }

    @Override
    public Expression sub(Expression input) {
        if (input.eq(ZERO)) {
            return this;
        }
        if (this.eq(ZERO)) {
            return input.neg();
        }
        Expression r1 = this.clone();
        Expression r2 = input.clone();
        Multinomial denom_out = this.normilize_denominators(r1, r2);
        Expression output = new Expression(r1.getNum().sub(r2.getNum()), denom_out);
        return output;
    }

    @Override
    public Expression neg() {
        return new Expression(this.num.neg(), this.denom);
    }

    @Override
    public Expression mult(Expression r) {
        Expression o_1 = new Expression(this.num, r.getDenom());
        o_1.simplify();
        Expression o_2 = new Expression(r.getNum(), this.denom);
        o_2.simplify();
        Multinomial output_num = o_1.getNum().mult(o_2.getNum());
        Multinomial output_denom = o_1.getDenom().mult(o_2.getDenom());
        Expression output = new Expression(output_num, output_denom);
        return output.simplify();
    }

    @Override
    public Expression div(Expression r) {
        if (r.eq(ZERO)) {
            throw new Error("Cannot divide RationalMultinomials by 0");
        }
        return this.mult(r.mult_inverse());
    }

    public Expression mod(Expression input) {
        if (input.eq(ZERO)) {
            throw new Error("Cannot mod RationalMultinomials by 0");
        }
        Expression r1 = this.clone();
        Expression r2 = input.clone();
        Multinomial denom_out = this.normilize_denominators(r1, r2);
        Expression output = new Expression(r1.getNum().mod(r2.getNum()), denom_out);
        return output;
    }

    @Override
    public int compareTo(Expression input) {
        Expression r1 = this.clone();
        Expression r2 = input.clone();
        this.normilize_denominators(r1, r2);
        Multinomial n1 = r1.getNum();
        Multinomial n2 = r2.getNum();
        return n1.compareTo(n2);
    }

    @Override
    public Expression sqrt() {
        throw new Error("Unimplemented.");
    }

    @Override
    public boolean eq(Expression other) {
        return this.num.eq(other.num) && this.denom.eq(other.denom);
    }

    private Expression simplify() {
        if (this.denom.eq(0)) {
            throw new Error("RationalMultinomials cannot have denominators equal to 0!");
        }
        Multinomial gcd = this.Euclid(this.num, this.denom);
        this.num = this.num.div(gcd);
        this.denom = this.denom.div(gcd);
        if (this.denom.isNegative()) {
            this.num = this.num.neg();
            this.denom = this.denom.neg();
        }
        List<Complex> coefs = this.num.getCoefs();
        coefs.append((Data_Structure<Complex>)this.denom.getCoefs());
        List<IntB> denoms = new List<IntB>();
        for (Complex r : coefs) {
            denoms.add(r.part_real().getDenom());
            denoms.add(r.part_imaginary().getDenom());
        }
        IntB lcm = NumberMath.LCM(denoms);
        this.num = this.num.mult(new Multinomial(lcm));
        this.denom = this.denom.mult(new Multinomial(lcm));
        List<IntB> nums = new List<IntB>();
        for (Complex r : coefs) {
            nums.add(r.part_real().getNum());
            nums.add(r.part_imaginary().getNum());
        }
        IntB gcf = NumberMath.GCF(nums);
        this.num = this.num.div(new Multinomial(gcf));
        this.denom = this.denom.div(new Multinomial(gcf));
        return this;
    }

    public Multinomial normilize_denominators(Expression r1, Expression r2) {
        Multinomial denom1 = r1.getDenom();
        Multinomial denom2 = r2.getDenom();
        Multinomial lcm = this.LCM(denom1, denom2);
        Multinomial scalar1 = lcm.div(denom1);
        Multinomial scalar2 = lcm.div(denom2);
        r1.scale(scalar1);
        r2.scale(scalar2);
        return lcm;
    }

    private void scale(Multinomial scale) {
        this.num = this.num.mult(scale);
        this.denom = this.denom.mult(scale);
    }

    private Multinomial Euclid(Multinomial a, Multinomial b) {
        a = (Multinomial)a.abs();
        b = (Multinomial)b.abs();
        boolean reverse = false;
        while (!b.eq(0)) {
            Multinomial c = b;
            if ((b = a.mod(b)).eq(a)) {
                if (reverse) {
                    return Multinomial.ONE;
                }
                reverse = true;
            }
            a = c;
        }
        return a;
    }

    private Multinomial LCM(Multinomial a, Multinomial b) {
        return a.mult(b).div(this.Euclid(a, b));
    }

    public Multinomial getNum() {
        return this.num;
    }

    public Multinomial getDenom() {
        return this.denom;
    }

    @Override
    public int sign() {
        return this.num.sign();
    }

    public Expression mult_inverse() {
        return new Expression(this.denom, this.num);
    }

    public Multinomial part_int() {
        return this.num.div(this.denom);
    }

    public Expression part_frac() {
        Expression output = new Expression(((Multinomial)this.num.abs()).mod(this.denom), this.denom);
        if (this.num.isNegative()) {
            return output.neg();
        }
        return output;
    }

    @Override
    public boolean isPositive() {
        return this.num.isPositive();
    }

    @Override
    public boolean isNegative() {
        return this.num.isNegative();
    }

    @Override
    public Expression abs() {
        if (this.isNegative()) {
            return this.neg();
        }
        return this;
    }

    public Expression clone() {
        return new Expression(this.num, this.denom);
    }

    @Override
    public String toString() {
        if (this.denom.equals(Multinomial.ONE)) {
            return "" + this.num;
        }
        return "\\frac{" + this.num + "}{" + this.denom + "}";
    }

    @Override
    public void serializeTo(PrintStream stream) {
        stream.println(this.toSerialString());
    }

    public String toSerialString() {
        if (this.denom.equals(Multinomial.ONE)) {
            return this.num.toSerialString();
        }
        return "(" + this.num.toSerialString() + ")/(" + this.denom.toSerialString() + ")";
    }

    @Override
    public int hashCode() {
        return this.num.hashCode() + this.denom.hashCode();
    }

    @Override
    Expression N(long n) {
        if (n == 0L) {
            return ZERO;
        }
        if (n == 1L) {
            return ONE;
        }
        return new Expression(n);
    }

    private Multinomial I(long i) {
        return Multinomial.ONE.N(i);
    }

    public Expression pow(Expression power) {
        if (this.eq(0)) {
            return ZERO;
        }
        if (this.eq(1)) {
            return ONE;
        }
        if (power.eq(0)) {
            return ONE;
        }
        if (power.eq(1)) {
            return this;
        }
        if (power.isInt()) {
            IntB exponent = power.toIntB();
            if (exponent.isNegative()) {
                return ((Expression)this.pow(exponent.neg())).mult_inverse();
            }
            return (Expression)this.pow(exponent);
        }
        return this;
    }

    @Override
    public Expression conj() {
        Multinomial num_out = this.num.conj();
        if (num_out == this.num) {
            return this;
        }
        return new Expression(num_out, this.denom);
    }

    @Override
    public boolean isInt() {
        return this.denom.eq(1) && this.num.isInt();
    }

    @Override
    public IntB toIntB() {
        return this.num.toIntB();
    }

    @Override
    public int toInt() {
        return this.num.toInt();
    }
}

